/*:
 * @target MZ
 * @plugindesc ランダム位置に1行メッセージを表示し、自動消滅＆フェードアウト対応版
 * @author AI
 *
 * @param DisplayDuration
 * @text 表示時間(フレーム)
 * @type number
 * @default 60
 *
 * @param FadeDuration
 * @text フェード時間(フレーム)
 * @type number
 * @default 30
 *
 * @command ShowPopup
 * @text ポップアップ表示
 *
 * @arg text
 * @text 表示文字列
 * @type string
 * @default Hello!
 *
 * @arg variableId
 * @text 表示する変数ID
 * @type variable
 * @default 0
 *
 * @help
 * プラグインコマンドでランダム位置に小ウィンドウを表示。
 * 表示 → フェードアウト後に自動消滅します。
 * - DisplayDuration: フル表示している時間
 * - FadeDuration: 消えるまでのフェード時間
 */

(() => {
  const PLUGIN_NAME = "RandomPopupMessage";
  const params = PluginManager.parameters(PLUGIN_NAME);
  const DISPLAY_DURATION = Number(params["DisplayDuration"] || 60);
  const FADE_DURATION = Number(params["FadeDuration"] || 30);

  PluginManager.registerCommand(PLUGIN_NAME, "ShowPopup", args => {
    let text = args.text;
    const vid = Number(args.variableId);
    if (vid > 0) {
      text = String($gameVariables.value(vid));
    }
    SceneManager._scene.addPopupWindow(text);
  });

class PopupWindow extends Window_Base {
  constructor(text) {
    const dummy = new Rectangle(0, 0, 200, 100);
    super(dummy);

    const widthText = this.contents.measureTextWidth(text);
    const w = Math.min(Graphics.width, Math.max(80, widthText + this.padding * 2 + 20));
    const h = this.fittingHeight(1);

    const x = Math.randomInt(Graphics.width - w);
    const y = Math.randomInt(Graphics.height - h);
    this.move(x, y, w, h);

    this._text = text;
    this._life = DISPLAY_DURATION + FADE_DURATION;
    this._fadeStart = DISPLAY_DURATION;
    this.refresh();
  }

  refresh() {
    this.contents.clear();
    this.drawText(this._text, 0, 0, this.contents.width, "left");
    // this.contents.fontFace = "ＭＳ ゴシック"; ←等幅にしたいなら有効化
  }

  update() {
    super.update();
    if (this._life > 0) {
      this._life--;
      if (this._life <= this._fadeStart) {
        const ratio = this._life / FADE_DURATION;
        this.opacity = Math.floor(255 * ratio);
        this.contentsOpacity = this.opacity;
      }
      if (this._life === 0 && this.parent) {
        this.parent.removeChild(this);
      }
    }
  }
}



  Scene_Map.prototype.addPopupWindow = function(text) {
    const wnd = new PopupWindow(text);
    this.addWindow(wnd);
  };
})();
